/* Passage de données entre fonctions:
Version française de LEDs in 2D Array function
*/
/*LEDs in 2D Array Function
 by Becky Stewart
 for Adventures in Arduino, Wiley (2015)
 
 Hardware:
 * 5 LEDs
 * 5 220 Ohm resistors

Copyright 2015 Becky Stewart

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.  
 */

// const indique que les valeurs ne changeront pas !
const int nombreLED = 5 ;
const int nombreTrames = 9 ;
// Les numéros des plots reliés aux LED
int plotsLED [] = {2, 3, 9, 10, 11} ;
// Les trames de l’animation
int trames [nombreTrames] [nombreLED] =
{
{1, 0, 0, 0, 0},
{0, 1, 0, 0, 0},
{0, 0, 1, 0, 0},
{0, 0, 0, 1, 0},
{0, 0, 0, 0, 1},
{0, 0, 0, 1, 0},
{0, 0, 1, 0, 0},
{0, 1, 0, 0, 0},
{1, 0, 0, 0, 0}
};
void setup() {
  // Indiquer le mode de fonctionnement des plots
  int i;
  for(int i=0; i<nombreLED; i++) {
    pinMode( plotsLED[i], OUTPUT);
  }
}

void loop() {
  affichageAnimation( 100 );
  affichageAnimation( 500 );
  affichageAnimation( 1000 );
}

void affichageAnimation( int vitesseAnimation) {
  // variables pour mémoriser la trame et la LED en cours
  int trame;
  int led;
  for( trame=0; trame<nombreTrames; trame++ ) {
    // itération pour chaque trame mémorisée dans une colonne
    for( led=0; led<nombreLED; led++ ) {
      // allumer ou éteindre chaque LED de la trame
      digitalWrite( plotsLED[led], trames[trame][led] );
    }
    delay(vitesseAnimation); // pause entre chaque trame
  }
}

